/* Author: Gerhard Wickler <g.wickler@ed.ac.uk>
 * Updated: Wed Jun 21 16:55:56 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.util;

import java.io.File;
import java.util.*;

import javax.swing.filechooser.FileFilter;

public class FileExtensionFileFilter extends FileFilter {

    protected Collection allowed;
    protected String description = null;
    private boolean acceptDirs = true;
    private boolean caseSensitive = true;

    public FileExtensionFileFilter(String ext) {
        this.allowed = new LinkedList();
        allowed.add(ext);
    }

    public FileExtensionFileFilter(Collection exts) {
        if (exts.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.allowed = exts;
    }

    public void setCaseSensitive(boolean b) {
        this.caseSensitive = b;
    }

    public void setAcceptDirectories(boolean b) {
        this.acceptDirs = b;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return (description == null) ?
                "file extensions: " + this.toString() :
                description + "(" + this.toString() + ")";
    }

    public boolean accept(File pathname) {
        // accept directories:
        if (acceptDirs && (pathname.isDirectory())) {
            return true;
        }
        // extract the file extension:
        String ext = pathname.getName();
        int lastDot = ext.lastIndexOf('.');
        if (lastDot < 0) {
            // no file extension:
            return false;
        }
        ext = ext.substring(ext.lastIndexOf('.') + 1);
        // compare to allowed extensions:
        for (Iterator exti = allowed.iterator(); exti.hasNext(); ) {
            if (caseSensitive ?
                exti.next().equals(ext) :
                ext.compareToIgnoreCase((String) exti.next()) == 0) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        Iterator exti = allowed.iterator();
        String result = getStarDotString((String) exti.next());
        while (exti.hasNext()) {
            result += ", " + getStarDotString((String) exti.next());
        }
        return result;
    }

    private String getStarDotString(String ext) {
        return "*." + (caseSensitive ? ext : ext.toLowerCase());
    }

}
