/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Aug 30 00:29:11 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.util;

/**
 * Base implementation of an object used to undo something.
 */
public abstract class AbstractUndoAction implements UndoAction {

    private String note;

    public AbstractUndoAction(String note) {
        this.note = note;
    }

    /**
     * Returns a short note that describes what this action is about.
     */
    public String getNote() {
        return note;
    }

    public String toString() {
        return "UndoAction[" + note + "]";
    }

}
