/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Sep 30 21:41:21 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.test.xml;

import java.util.*;

import ix.util.*;

/**
 * A possibly useful representation of a Map.Entry.
 *
 * @see Mapping
 */
public class MapEntry implements Map.Entry {

    protected Object key;
    protected Object value;

    public MapEntry() { }

    public MapEntry(Object key, Object value) {
	this.key = key;
	this.value = value;
    }

    public MapEntry(Map.Entry e) {
	this.key = e.getKey();
	this.value = e.getValue();
    }

    public Object getKey() { return key; }
    public void setKey(Object key) { this.key = key; }

    public Object getValue() { return value; }
    public Object setValue(Object value) {
	Object old = this.value;
	this.value = value;
	return old;
    }

    public int hashCode() {
	// Formula give by the javadoc for Map.Entry
	return (getKey() == null ? 0 : getKey().hashCode())
	    ^  (getValue() ==null ? 0 : getValue().hashCode());
    }

    public boolean equals(Object obj) {
	// Formula give by the javadoc for Map.Entry
	if (!(obj instanceof Map.Entry))
	    return false;
	Map.Entry e1 = this;
	Map.Entry e2 = (Map.Entry)obj;
	return (e1.getKey() == null
		? e2.getKey() == null
		: e1.getKey().equals(e2.getKey()))
	    && (e1.getValue() == null
		? e2.getValue() == null
		: e1.getValue().equals(e2.getValue()));
    }

}
