/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Nov  7 06:39:19 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.test.xml;

import java.io.Serializable;

import ix.util.*;
import ix.util.lisp.*;

/**
 * Allows {@link LList}s to be written in XML using their ordinary
 * textual syntax.  For example:
 * <pre>&lt;list-text&gt;((filling ?pie) = apple)&lt;/list-text&gt;</pre>
 *
 * @see Lisp#readFromString(String)
 */
public class ListText implements SemiPrimitive, Serializable {

    public static Object valueOf(String text) {
	return Lisp.readFromString(text);
    }

}
