/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Jul  1 23:49:59 2007 by Jeff Dalton
 * Copyright: (c) 2004, 2005, 2007, AIAI, University of Edinburgh
 */

package ix.test.xml;

import java.util.*;

import ix.icore.plan.Plan;
import ix.icore.domain.Domain;

import ix.iplan.AutoTester;
import ix.iplan.PlanTest;
import ix.iplan.PlanCheckingSimulator;
import ix.iplan.Slip;		// for some symbols /\/

import ix.test.BlockStacker;
import ix.test.HtnBlockStacker;
import ix.test.PrecondBlockStacker;

import ix.util.*;

/**
 * Describes a block-stacking plan test.
 */
public class BlockStackingTest extends PlanTest {

    String problem;

    public BlockStackingTest() {
        super();
    }

    public String getProblem() {
	return problem;
    }

    public void setProblem(String problem) {
	this.problem = problem;
    }

    public void setTask(String task) {
	throw new UnsupportedOperationException();
    }

    public void setInitialPlan(String initialPlan) {
	throw new UnsupportedOperationException();
    }

    public String testDescription() {
	return "Domain " + getDomain() +
	    ", Problem " + getProblem();
    }

    public String taskDescription() { // needed by savePlan
	return getProblem();
    }

    public AutoTester.TestRunner makeTestRunner(AutoTester auto) {
	return new BlockTestRunner(this, auto);
    }

    static class BlockTestRunner extends AutoTester.TestRunner {

	AutoTester auto;
	BlockStacker stacker;
	BlockStackingTest test;

	BlockTestRunner(BlockStackingTest test, AutoTester auto) {
	    auto.super(test);
	    this.auto = auto;
	    this.test = test;
	}

	// /\/: Relies on readDomain() being called before initialPlan(),
	// because we don't know what kind of BlockStacker to create
	// until we look at the domain.

	protected Domain readDomain() {
	    Domain baseDomain = super.readDomain();
	    stacker = makeBlockStacker(baseDomain);
	    Domain domain = stacker.problemDomain();
	    domain.takeFrom(baseDomain);
	    return domain;
	}

	private BlockStacker makeBlockStacker(Domain dom) {
	    return dom.getAnnotation(Slip.S_ACHIEVABLE_CONDS) == Slip.K_NONE
		? new HtnBlockStacker(test.getProblem())
		: new PrecondBlockStacker(test.getProblem());
	}

	protected Plan initialPlan() {
	    return stacker.initialPlan();
	}

	protected Map runSimulation(PlanCheckingSimulator sim) {
	    Map result = super.runSimulation(sim);
	    List fails = stacker.failedGoalPatterns(sim.getWorldStateMap());
	    if (!fails.isEmpty())
		auto.testFailure(test, "False patterns " + fails);
	    else
		auto.traceln("World state is correct");
	    return result;
	}

    }

}
