/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Sep 29 16:05:26 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2003, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.icore.*;
import ix.ip2.*;
import ix.util.*;
import ix.util.lisp.*;

/**
 * A simple automatic handler.
 */
public class TestAutoHandler extends ActivityHandler {

    Ip2 ip2;

    public TestAutoHandler(Ip2 ip2) {
	super("Handle auto actions automatically");
	this.ip2 = ip2;
    }

    public List getSyntaxList() {
	return (LList)Lisp.readFromString
	    ("((auto ?whatever ...))");
    }

    public boolean appliesTo(AgendaItem item) {
	LList pattern = item.getPattern();
	return pattern.get(0).toString().equals("auto");
    }

    public boolean isAutomatic() {
	return true;
    }

    public void addHandlerActions(AgendaItem item) {
	item.addAction
	    (new HandlerAction.AutomaticWhenBound(item, this));
    }

    public void handle(AgendaItem item) {
	item.setComments("Automatically handled");
	item.setStatus(Status.COMPLETE);
	// ip2.getController().getAgenda(item.getAbout()).addItem(item);
	ip2.getController().addHandledItem(item);
    }

}
