/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Aug 23 03:27:30 2007 by Jeff Dalton
 * Copyright: (c) 2004 - 2007, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.iplan.*;
import ix.icore.*;
import ix.icore.plan.*;
import ix.icore.plan.build.*;
import ix.icore.domain.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.*;

/**
 * Used for running planning problems.
 */
public class PlanningTest {

    // Parameters that can be given by command-line arguments
    protected String domainName;
    protected String planName;
    protected String task;

    // Objects we create
    protected Planner planner;
    protected Domain domain;

    public PlanningTest() {
    }

    public static void main(String[] argv) {
	Debug.off();
	Parameters.processCommandLineArguments(argv);
	PlanningTest ptest = new PlanningTest();
	ptest.run();
    }

    protected void run() {
	setup();
	planner.plan();
	while (true) {
	    planner.getStatistics().report(System.out);
	    checkPlan();
	    if (Util.askLine("Replan?").trim().startsWith("y"))
		planner.replan();
	    else
		System.exit(0);
	}
    }

    protected void setup() {
	domainName = Parameters.getParameter("domain");
	planName = Parameters.getParameter("plan");
	task = Parameters.getParameter("task");
	planner = IPlan.makeDefaultPlanner();
	if (domainName != null) {
	    domain = XML.readObject(Domain.class, domainName);
	    planner.setDomain(domain);
	}
	if (planName != null)
	    planner.loadPlan(XML.readObject(Plan.class, planName));
	if (task != null)
	    planner.loadPlan(initialPlan(task));
    }

    protected Plan initialPlan(String task) {
	PlanBuilder builder = new SimplePlanBuilder();
	LList taskPattern = Lisp.elementsFromString(task);
	builder.addActivity(new Activity(taskPattern));
	return builder.getPlan();
    }

    protected void checkPlan() {

	// Simulate plan execution.
	PlanCheckingSimulator sim =
	    new PlanCheckingSimulator(planner.getPlan(), domain);
	sim.run();

	// Print a report that describes any problems found.
	sim.report();

	// Describe the changes in the world state
	sim.describeChangedWorldState();

    }

}
