/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Jun 26 04:04:19 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;
import java.io.*;

import java.math.BigInteger;

import ix.util.*;
import ix.util.lisp.*;

public class LongToBytes {

    public static void main(String[] argv) {
	for (;;) {
	    String in = Util.askLine("Long:");
	    if (in.equals("bye"))
		return;
	    Long L = (Long)Lisp.readFromString(in);
	    long l = L.longValue();
	    byte[] bytes = longToBytes(l);
	    System.out.println(printName(bytes));
	    System.out.println("= " + bytesToLong(bytes));
	    System.out.println("= " + bytesToLongStrings(bytes));
	    System.out.println("= " + encode(l));
	    System.out.println("");
	}
    }

    static String printName(byte[] bytes) {
	StringBuffer buf = new StringBuffer();
	buf.append("byte[")
	   .append(bytes.length)
	   .append("]{");
	for (int i = 0; i < bytes.length - 1; i++) {
	    buf.append(bytes[i]).append(", ");
	}
	buf.append(bytes[bytes.length - 1])
           .append("}");
	return buf.toString();
    }

    /**
     * Converts a long to a (big-endian) array of bytes.
     */
    public static byte[] longToBytes(long l) {
	byte[] bytes = new byte[8];
	int shift = 56, i = 0;
	while (shift >= 0) {
	    long shifted = l >> shift;
	    bytes[i] = (byte)(shifted & 255);
	    shift -= 8;
	    i++;
	}
	return bytes;
    }

    /**
     * Converts a (big-endian) array of bytes to a long
     */
    public static long bytesToLong(byte[] bytes) {
	long l = 0;
	for (int i = 0; i < bytes.length; i++) {
	    l = l << 8;
	    l |= (bytes[i] & 255);
	}
	return l;
    }

    /**
     * Converts an array of bytes to a string containing the
     * "/"-separated string representations of longs taken from
     * the array.  This is done by wrapping a DataInputStream
     * around a ByteArrayInputStream based on the array, to
     * get the longs, and calling {@link #encode(long)}
     * to get the string representations.
     *
     * <p>It is assumed that the length of the byte array
     * is a multiple of 8.
     */
    public static String bytesToLongStrings(byte[] bytes) {
	DataInputStream in =
	    new DataInputStream(new ByteArrayInputStream(bytes));
	StringBuffer result = new StringBuffer();
	try {
	    while (in.available() > 0) {
		if (result.length() > 0)
		    result.append("/");
		result.append(encode(in.readLong()));
	    }
	}
	catch(IOException e) {
	    throw new RethrownException(e);
	}
	return result.toString();
    }

    public static String encode(long l) {
	Debug.expect(DIGITS.length() == 64);
	boolean negate = l < 0;
	StringBuffer result = new StringBuffer();
	BigInteger L = BigInteger.valueOf(l);
	BigInteger Zero = BigInteger.valueOf(0);
	BigInteger SixtyFour = BigInteger.valueOf(64);
	if (negate)
	    L = L.negate();
	while (L.compareTo(Zero) > 0) {
	    BigInteger[] divRem = L.divideAndRemainder(SixtyFour);
	    int rem = divRem[1].intValue();
	    result.insert(0, DIGITS.charAt(rem));
	    L = divRem[0];
	}
	if (negate)
	    result.insert(0, "-");
	return result.toString();
    }

    private static final String DIGITS =
	"0123456789~abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ";

}
