/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Jan 16 03:02:24 2004 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.test;

import java.awt.event.*;
import java.util.*;

import javax.swing.*;

import ix.icore.*;
import ix.ip2.*;
import ix.iface.util.ToolController;
import ix.iface.util.IFUtil;
import ix.util.*;
import ix.util.lisp.*;


/**
 * An example of various ways to entend BasicIp2.
 */

public class Ip2Example extends Ip2 {

    public Ip2Example() {
	super();

	// Change some defaults
	displayName = "Ip2 Example";
	symbolName = "Example";
	logoLine1 = "Example I-X Process Panel";
	logoLine2 = "Based on I-X Technology";
	logoImage = "ip2-logo.gif";

    }

    public static void main(String[] argv) {

	Util.printGreeting("IP2 Example");

	new Ip2Example().mainStartup(argv);

    }


    /**
     * Command-line argument processing.
     */
    protected void processCommandLineArguments() {
	super.processCommandLineArguments();
    }


    /**
     * Completes setup and initialization.
     */
    protected void completeStartup() {

	// Add a tool.
	addExampleTool();

	// Add a menu item in a new menubar menu.
	JMenuItem boo = IFUtil.makeMenuItem("Boo!", new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		Util.displayAndWait(null, "Boo!");
	    }
	});
	IFUtil.addMenuBarItem(frame, "Example Menu", boo);

	// Also add one to the "File" menu, but put it first in
	// the file menu.  (addMenuBarItem would put it last.)
	JMenuItem boo2 = IFUtil.makeMenuItem("Boo!", new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		Util.displayAndWait(null, "Boo!");
	    }
	});
	// IFUtil.addMenuBarItem(frame, "File", boo2);
	JMenu fileMenu = IFUtil.ensureMenuBarMenu(frame, "File");
	fileMenu.add(boo2, 0);

	// /\/: Not clear whether we should do this first or last.
	super.completeStartup();

    }

    /**
     * Adds a simple tool.
     */
    protected void addExampleTool() {
	addTool(new ExampleToolController("Example Tool"));
    }

    protected class ExampleToolController extends ToolController {
	public ExampleToolController(String name) {
	    super(name);
	}
	public Object createTool() {
	    return new ix.util.xml.XMLTreeEditFrame
		(Ip2Example.this,
		 Ip2Example.this.getAgentDisplayName() + " XML Tree Editor");
	}
    }

    /**
     * Called to add items to the main frame menu bar's "Test" menu.
     */
    protected void addTestMenuItems() {
	super.addTestMenuItems();
    }

    /**
     * Called to add issue and activity handlers.
     */
    protected void addHandlers() {
	super.addHandlers();
	getController().addActivityHandler(new ChangeSymbolNameHandler(this));
    }

}
