/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Aug  9 02:48:30 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.test;

import java.net.*;
import java.io.*;
import java.util.*;

import ix.util.*;

/**
 * A test the makes HTTP POST requests.
 */
public class HttpRequestTest {

    public static void main(String[] argv)
        throws MalformedURLException,
	       ProtocolException,
	       IOException {

	while (true) {

	    // Get a URL for the request
	    URL url = new URL(Util.askLine("URL:"));

	    // Ask the user for something to send.
	    System.out.println("Type some XML followed by a blank line:");
	    List lines = new LinkedList();
	    while (true) {
		String line = Util.readLine(System.in);
		if (line.equals(""))
		    break;
		lines.add(line);
	    }
	    String contents = Strings.joinLines(lines);

	    // Convert the contents to bytes so that we can see
	    // how long it is.
	    byte[] bytes = contents.getBytes("UTF-8");

	    // Set up a connection to the URL.
	    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
	    conn.setDoInput(true);
	    conn.setDoOutput(true);
	    conn.setUseCaches(false);
	    conn.setRequestMethod("POST");
	    conn.setRequestProperty("Content-Length", ""+bytes.length);
	    conn.setRequestProperty("Content-Type",
				    "application/xml; charset=UTF-8");
	    conn.setRequestProperty("Host", 
				    url.getHost() + ":" + url.getPort());

	    // Connect.
	    conn.connect();

	    // Send the request.
	    OutputStream out = conn.getOutputStream();
	    out.write(bytes);
	    out.flush();
	    out.close();

	    // Describe the response.
	    System.out.println("");
	    System.out.println("Response:");
	    System.out.println(conn.getResponseCode() + " " +
			       conn.getResponseMessage());

	    System.out.println("");
	    System.out.println("Reply Headers:");
	    for (Iterator i = conn.getHeaderFields().entrySet().iterator()
		     ; i.hasNext(); ) {
		Map.Entry e = (Map.Entry)i.next();
		System.out.println(e.getKey() + ": " + e.getValue());
	    }

	    // Read the reply contents.
	    InputStream in = conn.getInputStream();
	    String encoding = conn.getContentEncoding();
	    Reader r = encoding == null
		? new InputStreamReader(in)
		: new InputStreamReader(in, encoding);

	    int len = conn.getContentLength();
	    String result = "";
	    if (len < 0) {
		Debug.noteln("No contet length; will read everything.");
		result = readAllLines(r);
		r.close();
	    }
	    else {
		result = readText(r, len);
		r.close();
		if (result == null)
		    throw new RuntimeException("EOF");
	    }

	    System.out.println("");
	    System.out.println("Reply:");
	    System.out.println(result);

	}

    }

    static String readText(Reader r, int len) throws IOException {
	char[] content = new char[len];
	int need = len;
	int at = 0;
	while (need > 0) {
	    int obtained = r.read(content, at, need);
	    if (obtained == -1) { // end reached
		return null;
	    }
	    need -= obtained;
	    at += obtained;
	}
	return new String(content);
    }

    static String readAllLines(Reader r) throws IOException {
	BufferedReader buf = new BufferedReader(r);
	List lines = new LinkedList();
	String line;
	while ((line = buf.readLine()) != null)
	    lines.add(line);
	return Strings.joinLines(lines);
    }

}
