/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Jul  1 23:16:50 2007 by Jeff Dalton
 * Copyright: (c) 2004, 2005, 2007, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.icore.*;
import ix.icore.domain.*;

import ix.iview.SimpleDomainEditor;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.*;

/**
 * A class for running block-stacking planning problems using
 * a purely HTN domain.
 */
public class HtnBlockStacker extends BlockStacker {

    public HtnBlockStacker(String problem) {
	super(problem);
    }

    protected String getDefaultBaseDomainName() {
	return "test-domains/blocks-pure-htn-1.lsp";
    }

    public static void main(String[] argv) {
	Parameters.processCommandLineArguments(argv);
	String outFile = Parameters.getParameter("output");
	String problem = Parameters.getParameter("problem");
	Debug.expect(problem != null, "No problem specified");
	BlockStacker stacker = new HtnBlockStacker(problem);
	stacker.findPlan();
	while (true) {
	    stacker.checkPlan();
	    if (outFile != null) {
		XML.writeObject(stacker.getPlan(), outFile);
	    }
	    if (Util.askLine("Replan?").trim().startsWith("y"))
		stacker.replan();
	    else
		System.exit(0);
	}
    }

    protected Refinement goalStateRefinement(List finalTowers) {
	Refinement r = new Refinement("problem-goal",
				      pattern("(problem-goal)"));
	// For each tower, (ACHIEVE (ON ...)) actions that construct it.
	ListOfNodeSpec nodes = new LinkedListOfNodeSpec();
	int nodeID = 1;
	for (Iterator i = finalTowers.iterator(); i.hasNext();) {
	    List tower = (List)i.next();
	    List onPatterns = towerPatterns(tower);
	    Collections.reverse(onPatterns);
	    for (Iterator j = onPatterns.iterator(); j.hasNext();) {
		LList onPat = (LList)j.next();
		LList achievePat = Lisp.list(S_ACHIEVE, onPat);
		nodes.add(new NodeSpec(nodeID++, achievePat));
	    }
	}
	// Make the nodes sequential.
	r.setNodes(nodes);
	r.setOrderings
	  (SimpleDomainEditor.sequentialOrderings(r.getNodes()));
	return r;
    }

}
