/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb 14 12:16:12 2007 by Jeff Dalton
 * Copyright: (c) 2007, AIAI, University of Edinburgh
 */

package ix.test;

import java.io.*;
import java.util.*;

import ix.icore.domain.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.*;

/**
 * Fixes a domain in some fashion.  (This class may be edited
 * and recompiled to perform whatever fix is required at the time.)
 * Outputs to a file of the same name in /tmp.
 */
public class FixDomain {

    FixDomain() {
    }

    public static void main(String[] argv) {
	// Debug.off();
	Parameters.setIsInteractive(false);
	FixDomain fixer = new FixDomain();

	Debug.noteln("XML Config:", XML.config());

	String domainName = argv[0];

	fixer.fix(domainName);
    }

    void fix(String domainName) {
	Domain domain = (Domain)XML.readObject(Domain.class, domainName);
	Domain newDomain = (Domain)new Fixer().copy(domain);
	File in = new File(domainName);
	String out = "/tmp/" + in.getName();
	Debug.noteln("out =", out);
	XML.writeObject(newDomain, out);
    }

    class Fixer extends ObjectCopier{
	public Object mapElement(Object obj) {
	    return obj instanceof PatternAssignment
		? mapPV((PatternAssignment)obj)
		: copy(obj);
	}
	PatternAssignment mapPV(PatternAssignment pv) {
	    Object v = pv.getValue();
	    if (v != null && v instanceof String) {
		Symbol sym = Symbol.intern((String)v);
		return new PatternAssignment(pv.getPattern(), sym);
	    }
	    else
		return pv;
	}
    }

}
