/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu May 30 03:18:05 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.ispace;

import java.util.*;

import ix.util.*;

/**
 * A base class that can support both intensionally and extensionally
 * secified groups.
 */
public abstract class AbstractAgentGroup implements AgentGroup {

    String name;
    ContactManager contactManager;

    public AbstractAgentGroup(String name, ContactManager cm) {
	this.name = name;
	this.contactManager = cm;
    }

    /**
     * Returns the name of this AgentGroup.
     */
    public String getName() {
	return name;
    }

    /**
     * Returns the collection of AgentData objects from which this
     * group's members are selected.  The implementation in this
     * class returns the full collection of agents known to the
     * contact manager.  Note that a Collection object is always
     * returned, never <code>null</code>.
     *
     * @see AgentData
     * @see ContactManager#getAgentData()
     */
    public Collection getBasePopulation() {
	return contactManager.getAgentData();
    }

    /**
     * A test that is applied to members of the base population to
     * select the members of this group.  The implementation in this
     * class always returns true.
     */
    public boolean isMember(Object item) {
	return true;
    }

    /**
     * Returns the collection obtained by using the isMember method
     * to filter the base population.
     */
    public Collection getKnownMembers() {
	return Collect.filter(getBasePopulation(), new Predicate1() {
	    public boolean trueOf(Object item) {
		return isMember(item);
	    }
	});
    }

}
