/* Author: Gerhard Wickler <g.wickler@ed.ac.uk>
 * Updated: Wed Jun 21 17:22:36 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.isim;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;

import javax.swing.*;

public class StartSimDialog extends JDialog {

    protected boolean startSelected = false;
    protected long startTime;
    protected double acceleration;

    private DateFormat df = DateFormat.getDateTimeInstance(
            DateFormat.MEDIUM, DateFormat.SHORT);

    JPanel mainPanel = new JPanel();
    BorderLayout mainPanelLayout = new BorderLayout();
    JPanel paramPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JButton cancelButton = new JButton();
    JButton startButton = new JButton();
    GridLayout paramLayout = new GridLayout();
    JPanel startTimePanel = new JPanel();
    JPanel accelerationPanel = new JPanel();
    JLabel startTimeLabel = new JLabel();
    JTextField startTimeTextField = new JTextField();
    JLabel accelerationLable = new JLabel();
    JTextField accelerationTextField = new JTextField();

    public StartSimDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            setDefaultCloseOperation(DISPOSE_ON_CLOSE);
            jbInit();
            pack();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public StartSimDialog() {
        this(new Frame(), "StartSimDialog", false);
    }

    private void jbInit() throws Exception {
        mainPanel.setLayout(mainPanelLayout);
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(
            new StartSimDialog_cancelButton_actionAdapter(this));
        startButton.setFont(new java.awt.Font("Dialog", Font.BOLD, 11));
        startButton.setText("Start");
        startButton.addActionListener(
            new StartSimDialog_startButton_actionAdapter(this));
        paramPanel.setLayout(paramLayout);
        paramLayout.setColumns(1);
        paramLayout.setRows(2);
        startTimeLabel.setText("Simulation Start Time: ");
        startTimeTextField.setPreferredSize(new Dimension(150, 21));
        startTimeTextField.setText(df.format(new Date()));
        accelerationLable.setText("Time Acceleration Factor: ");
        accelerationTextField.setPreferredSize(new Dimension(50, 21));
        accelerationTextField.setText("1.0");
        mainPanel.setPreferredSize(new Dimension(300, 80));
        getContentPane().add(mainPanel);
        mainPanel.add(paramPanel, java.awt.BorderLayout.CENTER);
        paramPanel.add(startTimePanel);
        startTimePanel.add(startTimeLabel);
        startTimePanel.add(startTimeTextField);
        paramPanel.add(accelerationPanel);
        accelerationPanel.add(accelerationLable);
        accelerationPanel.add(accelerationTextField);
        this.getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);
        buttonPanel.add(startButton);
        buttonPanel.add(cancelButton);
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        dispose();
    }

    public void startButton_actionPerformed(ActionEvent e) {
        try {
            startTime = df.parse(startTimeTextField.getText()).getTime();
        } catch (java.text.ParseException pe) {
            startTimeTextField.setText(df.format(new Date()));
            startTimeTextField.setBackground(Color.RED);
            java.awt.Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            acceleration = Double.parseDouble(accelerationTextField.getText());
        } catch (NumberFormatException nfe) {
            accelerationTextField.setText("1.0");
            accelerationTextField.setBackground(Color.RED);
            java.awt.Toolkit.getDefaultToolkit().beep();
            return;
        }
        startSelected = true;
        dispose();
    }

}


class StartSimDialog_cancelButton_actionAdapter implements ActionListener {
    private StartSimDialog adaptee;
    StartSimDialog_cancelButton_actionAdapter(StartSimDialog adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.cancelButton_actionPerformed(e);
    }
}


class StartSimDialog_startButton_actionAdapter implements ActionListener {
    private StartSimDialog adaptee;
    StartSimDialog_startButton_actionAdapter(StartSimDialog adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.startButton_actionPerformed(e);
    }


}
