/* Author: Gerhard Wickler <g.wickler@ed.ac.uk>
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.isim;

import ix.icore.IXAgent;

import java.awt.*;
import java.text.DateFormat;
import java.util.Date;

import javax.swing.JLabel;
import javax.swing.JPanel;

import ix.iface.util.ToolFrame;

/**
 * This class is used by an ISimTimer to display current simulated time. The
 * function setTime(...) should be called on a regular basis to update the
 * displayed time.
 */
public class ISimTimeFrame extends ToolFrame {

    final static private Color RUNCOLOR = Color.GREEN.darker();
    final static private Color NORUNCOLOR = Color.RED;

    // GUI components added by jbInit:
    BorderLayout clockLayout = new BorderLayout();
    JPanel timePanel = new JPanel();
    JLabel simTimeLabel = new JLabel();

    // used for creating the String representing current simulated time:
    private DateFormat df = DateFormat.getDateTimeInstance(
            DateFormat.MEDIUM, DateFormat.SHORT);

    /**
     * creates and initializes the frame displaying simulated time
     */
    public ISimTimeFrame() {
        try {
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * initializes the GUI components of this frame
     * @throws Exception
     */
    private void jbInit() throws Exception {
        this.setTitle(IXAgent.getAgent().getAgentDisplayName() +
                      " I-Sim Time");
        this.setSize(new Dimension(225, 70));

        simTimeLabel.setFont(new java.awt.Font("Dialog", Font.PLAIN, 24));
        simTimeLabel.setForeground(NORUNCOLOR);
        simTimeLabel.setText("(not started)");
        timePanel.add(simTimeLabel);
        this.getContentPane().setLayout(clockLayout);
        this.getContentPane().add(timePanel, BorderLayout.CENTER);
    }

    /**
     * This function updates the current simulated time in the display.
     * @param time the new time to be displayed
     */
    public void setTime(long time) {
        simTimeLabel.setText(df.format(new Date(time)));
    }

    /**
     * This function should be called when the simulated clock is running.
     * It changes the font colour to green.
     */
    public void setRunning() {
        simTimeLabel.setForeground(RUNCOLOR);
    }

    /**
     * This function should be called when the simulated clock is paused.
     * It changes the font colour to red.
     */
    public void setPaused() {
        simTimeLabel.setForeground(NORUNCOLOR);
    }
}
