/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Feb 17 19:02:17 2006 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.iscript;

import java.io.*;

import org.jdom.Document;
import org.jdom.output.XMLOutputter;
import org.jdom.output.Format;

import ix.util.*;
import ix.util.xml.*;

/**
 * The root class of IScript expressions.
 */
public abstract class Expression implements Serializable {

    protected static XMLOutputter outputter = null;

    public Expression() {
        super();
    }

    public String toString() {
	Document doc = XML.objectToDocument(this);
	StringWriter writer = new StringWriter();
	ensureOutputter();
	try {
	    outputter.output(doc, writer);
	}
	catch (IOException e) {
	    throw new XMLException
		("Can't convert " + this + " to string", e);
	}
	writer.flush();
	return writer.toString();
    }

    private void ensureOutputter() {
	outputter = XML.makePrettyXMLOutputter();
	Format f = outputter.getFormat(); // copies
	f.setOmitDeclaration(true);
	outputter.setFormat(f);
    }

}
