/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri May 25 04:05:15 2007 by Jeff Dalton
 * Copyright: (c) 2004 - 2005, 2007, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.util.*;

import ix.ip2.*;
import ix.icore.*;
import ix.icore.process.*;
import ix.icore.domain.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;

/**
 * Expands a node.
 */
class SlipExpandNode implements Slip.Step {

    Slip slip;
    PNode node;
    LinkedList expanders;

    SlipExpandNode(Slip slip, PNode node, LinkedList expanders) {
	this.slip = slip;
	this.node = node;
	this.expanders = expanders;
    }

    public void run() {
	nextExpansion();
    }

    void nextExpansion() {
	// Find the first expander that's still valid.
	SlipExpander expander = getValidExpander();
	// If there are any expanders left, post an alt that will try them.
	if (!expanders.isEmpty())
	    slip.postAlternative(new Resume());
	// The expander does some of the work.  Right modularity? /\/
	expander.doExpansion();
	// If it's a goal node, turn it into a normal node.
	if (slip.isGoalNode(node))
	    fixupGoalNode(node);
	// Get filter conds from the instantiated refinement.
	ListOfConstraint conds =
	    node.getRefinement().getFilterConstraints();
	Debug.noteln("Instantiated conds", conds);
	// If no conds, we're done.
	if (conds.isEmpty()) {
	    slip.execBegin(node.getBegin());
	    // Now we're back to finding the next executable.
	    slip.setNextStep(new SlipFindExecutable(slip));
	    return;
	}
	// Next, satisfy the conditions.
	if (expander.isExpandLater())
	    slip.setNextStep(new SlipAchieveConds(slip, node, conds));
	else
	    slip.setNextStep(new SlipSatisfyConds(slip, node, conds));

    }

    private SlipExpander getValidExpander() {
	while (!expanders.isEmpty()) {
	    SlipExpander e = (SlipExpander)expanders.removeFirst();
	    if (e.isStillValid())
		return e;
	    Debug.noteln("Rejected expander", e);
	}
	throw slip.poison("No valid expanders for " + node);
    }

    void fixupGoalNode(PNode node) {
	ActivityItem item = (ActivityItem)node;
	Debug.noteln("Fixing up", item);
	slip.normalizeGoalNode(item);
	Debug.noteln("Item is now", item);
    }

    class Resume extends Alternative {

	public void run() {
	    nextExpansion();
	}

    }

}
