/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Jan 30 19:37:38 2005 by Jeff Dalton
 * Copyright: (c) 2004, 2005, AIAI, University of Edinburgh
 */

package ix.iplan;

import ix.util.xml.XML;

/**
 * Specifies default values for PlanTests.  If an instance of this
 * class appears in a list of PlanTests given to an {@link AutoTester},
 * the AutoTester will use this instance to supply default values
 * to later tests in the same list.  That happens via the
 * TestRunner returned by the {@link #makeTestRunner(AutoTester)}
 * method.
 */
public class PlanTestDefaults extends PlanTest {

    public PlanTestDefaults() {
        super();
    }

    /**
     * @throws UnsupportedOperationException if called.
     */
    void takeDefaults(PlanTest defaults) {
	throw new UnsupportedOperationException
	    ("PlanTestDefaults can't take default values");
    }

    /**
     * Returns a TestRunner that tells the AutoTester to use
     * this PlanTest for default values.
     *
     * @see PlanTest#takeDefaults(PlanTest)
     */
    public AutoTester.TestRunner makeTestRunner(final AutoTester auto) {
	return auto.new TestRunner(PlanTestDefaults.this) {
	    public void runTest() {
		auto.traceln("");
		auto.traceln("Setting plan-test defaults to",
			     XML.objectToXMLString(PlanTestDefaults.this));
		auto.setPlanTestDefaults(PlanTestDefaults.this);
	    }
	};
    }

    public String testDescription() {
	return "sets defaults";	// /\/
    }

}
