/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Sep 30 05:37:55 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.util.*;

import ix.icore.process.event.*;
import ix.ip2.*;
import ix.ip2.event.*;
import ix.util.*;

/**
 * Listens for changes in a process panel's current plan.
 */
public abstract class CombinedPlanChangeListener
       implements ProcessStatusListener, AgendaListener {

    public CombinedPlanChangeListener() {
    }

    public void connectYourself(Ip2 ip2) {
	ip2.getModelManager().addProcessStatusListener(this);
	ip2.getController().getActivityAgenda().addAgendaListener(this);
	ip2.getController().getIssueAgenda().addAgendaListener(this);
    }

    // ProcessStatusListener methods

    public void statusUpdate(ProcessStatusEvent e) {
	eventReceived(e);
    }

    public void newBindings(ProcessStatusEvent e, Map bindings) {
	eventReceived(e);
    }

    public void stateChange(ProcessStatusEvent e, Map delta) {
	eventReceived(e);
    }

    public void stateDeletion(ProcessStatusEvent e, Map delta) {
	eventReceived(e);
    }

    // AgendaListener methods

    public void setAgendaManager(AgendaManager am) {
    }

    public void itemAdded(AgendaEvent e, AgendaItem i) {
	eventReceived(e);
    }

    public void itemRemoved(AgendaEvent e, AgendaItem i) {
	eventReceived(e);
    }

    public void itemHandled(AgendaEvent e,
			    AgendaItem i,
			    HandlerAction a) {
	eventReceived(e);
    }

    public void newBindings(AgendaEvent e,
			    Map bindings) {
	eventReceived(e);
    }

    protected abstract void eventReceived(EventObject e);

}

// Issues:
// * This class exists only so that an option manager can notice
//   certain sorts of changes.
// * There ought to be an easier way to do this.  Also, it's
//   not clear that even this finds out about all relevant events.
//   It may also be necessary to listen to every individual
//   AgendaItem, for exaple.
