/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Feb 19 14:39:52 2008 by Jeff Dalton
 * Copyright: (c) 2004, 2008, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.util.*;

import ix.icore.*;
import ix.icore.domain.End;
import ix.icore.process.PNodeEnd;
import ix.ip2.*;

import ix.util.*;
import ix.util.context.*;

/**
 * Alternative -- a backtrack point.
 */
public abstract class Alternative implements Slip.Step {

    protected Context context;
    protected double cost = 0;

    public Alternative() {
	this.context = Context.getContext();
    }

    public Context getContext() {
	return context;
    }

    public double getCost() {
	return cost;
    }

    public void setCost(Slip slip) {
	// Called when the alt is posted.
	//\/ The parameter should allow any planning algorithm, not only Slip.
	this.cost = calcCost(slip);
    }

    protected double calcCost(Slip slip) {
	// return 0;
	return slip.MM().getNodes().size();
	// return fancy_calcCost(slip);
    }

    private double fancy_calcCost(Slip slip) {
	double cost = 0;
	for (PNodeEnd ne: slip.MM().getNodeEnds()) {
	    if (ne.getEnd() == End.END)
		continue;
	    ActivityItem act = (ActivityItem)ne.getNode();
	    Status status = slip.getStatus(ne);
	    if (status != Status.BLANK && status != Status.POSSIBLE)
		cost += 0;
	    else if (ne.getNode().isExpanded())
		cost += 0; // we'll count any subnodes when we come to them.
	    else if (slip.isGoalNode(ne))
// 		cost +=
// 		    slip.analysis
// 		      .getMinFullExpandSize(slip.getGoalCond(act.getBegin()));
		cost += 1;
	    else
		cost += 1+slip.analysis.getMinFullExpandSize(act.getPattern());
	}
	return cost;
    }

    public boolean isLocalChoice() {
	return false;
    }

    public void whenPicked() {
	// By default, this method does nothing.
    }

    public String toString() {
	return this.getClass().getName() + "[" +
	    "in " + context +
	    " cost " + cost +
	    extraToStringContents() +
	    "]";
    }

    protected String extraToStringContents() {
	return "";
    }

}

// Issues:
// * Perhaps the class should be named SlipAlternative?
