/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon May 21 03:20:30 2007 by Jeff Dalton
 * Copyright: (c) 2007, AIAI, University of Edinburgh
 */

package ix.ip2;

import javax.swing.*;

import java.util.*;

import ix.icore.process.PNodeEnd;

import ix.util.*;

/**
 * A very simple timeline viewer for I-P2.
 */
public class TimelineViewer {

    Ip2 ip2;

    TimelineFrame frame;

    public TimelineViewer(Ip2 ip2) {
	this.ip2 = ip2;
	frame = new TimelineFrame(ip2);
	ip2.addResetHook(new ResetHook());
	frame.addListener(new TimelineFrameListener());
	frame.reload();
    }

    public void setVisible(boolean v) {
	frame.setVisible(v);
    }

    protected class ResetHook implements Runnable {
	// Contexts have already been cleared by the time this is is called.
	public void run() {
	    Debug.noteln("Resetting", TimelineViewer.this);
	    // frame.reset();
	}
    }

    protected class TimelineFrame extends TextAreaFrame {
	public TimelineFrame(Ip2 ip2) {
	    this(ip2.getAgentDisplayName() +" Timeline");
	}
	public TimelineFrame(String title) {
	    super(0, 0, title, new String[]{"Reload", "Cancel"});
	    setEditable(false);
	}
	protected void finishFrame() {
	    // Doesn't make visible, unlike super method.
	    frame.pack();
	    frame.setSize(400, 300);
	    frame.validate();
	}
	public void reload() {
	    setText(makeTimelineText());
	}
	public void setText(String text) {
	    Debug.noteln("Timeline text", text);
	    super.setText(text);
	    setCaretPosition(0); // go to start of about text
	}
    }

    private class TimelineFrameListener implements TextAreaFrame.TListener {
	TimelineFrameListener() {}
	public void buttonPressed(String command) {
	    if (command.equals("Reload"))
		frame.reload();
	}
    }

    protected String makeTimelineText() {
	List text = new LinkedList();
	text.add("Timeline using earliest start times");
	text.add("");
	long t = 0;
	for (PNodeEnd e: getSortedEnds()) {
	    long min = e.getMinTime();
	    if (min != t) {
		t = min;
		text.add(new Duration(t).toString());
	    }
	    text.add("   " + e);
	}
	return Strings.joinLines(text);
    }

    List<PNodeEnd> getSortedEnds() {
	ip2.getIp2ModelManager().getTPNManager().describeTPN(Debug.out);
	List<PNodeEnd> ends = ip2.getIp2ModelManager().getNodeEnds();
	Collections.sort(ends, new Comparator<PNodeEnd>() {
		public int compare(PNodeEnd e1, PNodeEnd e2) {
		    return Long.signum(e1.getMinTime() - e2.getMinTime());
		}
	    });
	return ends;
    }

}
