/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Aug 30 01:08:21 2004 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.net.URL;
import java.net.MalformedURLException;
import java.util.*;

import ix.icore.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.*;

/**
 * Generates a {@link HandlerAction} that asks the HTML viewer
 * to display a URL.
 */
public class ShowURLHandler extends ActivityHandler {

    public static final Symbol S_SHOW_URL = Symbol.intern("show-url");

    protected Ip2 ip2;

    public ShowURLHandler(Ip2 ip2) {
	super("Show URL");
	this.ip2 = ip2;
    }

    public List getSyntaxList() {
	return (LList)Lisp.readFromString
	    ("((show-url ?url))");
    }

    public boolean appliesTo(AgendaItem item) {
	LList pattern = item.getPattern();
	return pattern.length() == 2
	    && pattern.get(0) == S_SHOW_URL;
    }
	
    public void addHandlerActions(AgendaItem item) {
	item.addAction
	    (new HandlerAction.AutomaticWhenBound(item, this));
    }

    public void handle(AgendaItem item) {
	LList pattern = (LList)Variable.removeVars(item.getPattern());
	String spec = pattern.get(1).toString();
	URL url = XML.toURL(spec);
	if (url == null)
	    throw new IllegalArgumentException
		("Can't make a URL from " + Strings.quote(spec));
	ip2.frame.ensureHTMLViewer().displayURL(url);
	item.setStatus(Status.COMPLETE);
    }

}
