/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Oct 19 15:31:35 2006 by Jeff Dalton
 * Copyright: (c) 2001 - 2004, 2006, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.icore.domain.Refinement;
import ix.icore.process.PNode;
import ix.util.match.MatchEnv;
import ix.util.lisp.LList;

/**
 * An AgendaEntry that represents an Issue.
 */
public class IssueItem extends AgendaItem {

    public IssueItem(Issue issue) {
	super(issue);
    }

    public IssueItem(IssueItem parent, Issue issue) {
	super(parent, issue);
    }

    public Map expandOneLevel(Refinement refinement, MatchEnv env) {
	throw new UnsupportedOperationException
	    ("Attempt to expandOneLevel for an issue using " + refinement);
    }

    protected PNode makePNode(PNode parent, LList pattern) {
	throw new UnsupportedOperationException("subissue creation");
    }

}

// Issues:
// * For IssueItems, there may be no need for AgendaItem to extend PNode.
//   So it might be better if ActivityItem relationship to PNodes
//   were inclusion rather than inheritance.
