/* Author: Jeff Dalton
 * Updated: Wed May 21 22:11:11 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.awt.Component;
import java.awt.BorderLayout;
import java.awt.event.*;

import javax.swing.*;

import java.util.*;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

import ix.iface.util.CatchingActionListener;
import ix.util.*;
import ix.util.xml.*;

import ix.test.xml.MapEntry;	// /\/

public class AnnotationEditor extends XMLTreeEditFrame {

    AnnotationEditor(Ip2 ip2) {
	super(ip2, ip2.getAgentDisplayName() + " Annotation");
	pack();
	editPanel.hideTemplates();
    }

    void editAnnotation(Object key, Object val) {
	editObject(new MapEntry(key, val));
	expandDocument(2); // expand 3 levels (depth 0..2)
    }

    void setAnnotation() {
	Debug.noteln("AnnotationEditor setAnnotation() called");
	MapEntry e = (MapEntry)getObject();
	((Ip2)agent).getModelManager()
	    .setAnnotation(e.getKey(), e.getValue());
    }

    protected XMLTreeEditPanel makeEditPanel() { // factory method
	return new AnnotationEditPanel();
    }

    class AnnotationEditPanel extends XMLTreeEditPanel {

	AnnotationEditPanel() {
	    super();
	}

	protected JPanel makeButtonPanel() {
	    JPanel panel = new JPanel();
	    // Stick with default flowlayout for now.
	
	    // Set Annotation
	    JButton setButton = new JButton("Set Annotation in I-P2");
	    ActionListener setListener = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    AnnotationEditor.this.setAnnotation();
		}
	    };
	    setButton.addActionListener
		(CatchingActionListener.listener(setListener));
	    panel.add(setButton);
	
	    // Cancel
	    JButton cancelButton = new JButton("Cancel");
	    ActionListener cancelListener = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    AnnotationEditor.this.setVisible(false);
		}
	    };
	    cancelButton.addActionListener
		(CatchingActionListener.listener(cancelListener));
	    panel.add(cancelButton);

	    return panel;
	}

    }

}
