/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Sep 13 06:37:15 2006 by Jeff Dalton
 * Copyright: (c) 2001 - 2006, AIAI, University of Edinburgh
 */

package ix.iface.util;

import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

import javax.swing.plaf.metal.OceanTheme;

import java.awt.Font;

import ix.util.Parameters;

/**
 * A Metal theme for I-X applications. <p>
 *
 * Use like this:
 * <pre>
 *   MetalLookAndFeel.setCurrentTheme(new IXMetalTheme());
 * </pre>
 */
public class IXOceanTheme extends OceanTheme {

    public IXOceanTheme() {
        super();
    }

//     public String getName() {
// 	return "IXOceanTheme";
//     }

    /*** Colours ***/

    // Primaries are the ones used in Java 1.3, which seem to have
    // turned into black and greys in 1.4.

    /*
    protected ColorUIResource getPrimary1() {
	return new ColorUIResource(0x666699);
    }

    protected ColorUIResource getPrimary2() {
	return new ColorUIResource(0x9999CC);
    }

    protected ColorUIResource getPrimary3() {
	return new ColorUIResource(0xCCCCFF);
    }

    // /\/: It's annoying that we need to define this in order
    // to get it to use the primary1 color.
    public ColorUIResource getSystemTextColor() {
	return getPrimary1();
    }
    */

    // secondary3, used as the general background color, is
    // settable by the user.

    private int secondary3_value =
	Parameters.getInt("metal-theme-secondary3", 0xCCCCCC);

    // private ColorUIResource secondary3 = new ColorUIResource(0xd1d1df);
    private ColorUIResource secondary3
	= new ColorUIResource(secondary3_value);

    protected ColorUIResource getSecondary3() {
        if (Parameters.haveParameter("metal-theme-secondary3"))
            return secondary3;
        else
            return super.getSecondary3();
    }

    /*** Fonts ***/

    private boolean changeFont = Parameters.haveParameter("font-increment");
    private int fontIncrement =	Parameters.getInt("font-increment", 0);

    public FontUIResource getControlTextFont() {
	return adjustFont(super.getControlTextFont());
    }

    public FontUIResource getSystemTextFont() {
	return adjustFont(super.getSystemTextFont());
    }

    public FontUIResource getUserTextFont() {
	return adjustFont(super.getUserTextFont());
    }

    public FontUIResource getMenuTextFont() {
	return adjustFont(super.getMenuTextFont());
    }

    public FontUIResource getWindowTitleFont() {
	return adjustFont(super.getWindowTitleFont());
    }

    public FontUIResource getSubTextFont() {
	return adjustFont(super.getSubTextFont());
    }

    protected FontUIResource adjustFont(FontUIResource font) {
	if (!changeFont) return font;
	
	// /\/: This qought to work:
	//
	// Font newFont = font.deriveFont(font.getSize() + fontIncrement);
	//
	// but it doesn't get the style right.  This does:
	//
	// Font newFont = font.deriveFont(font.getStyle(),
	//                                font.getSize() + fontIncrement);
	//
	// But for large fonts, it's better if we use PLAIN everywhere.
	// (Note that viewers can still embolden the font if they want to.)
	//
	// So:

	Font newFont = 
	    font.deriveFont(fontIncrement > 2 ? Font.PLAIN : font.getStyle(),
			    font.getSize() + fontIncrement);

	return new FontUIResource(newFont);

    }

}
