/* Author: Jeff Dalton
 * Updated: Tue Apr 25 19:15:56 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2006, AIAI, University of Edinburgh
 */

package ix.iface.util;

import javax.swing.*;
import java.awt.event.*;

import ix.util.Debug;

/**
 * An editable JComboBox that automatically adds any typed-in
 * items to the menu.
 */
public class ComboChoice extends JComboBox {

    public ComboChoice() {
	this(new Object[] {});
    }

    public ComboChoice(ComboBoxModel model) {
	super(model);
	this.setEditable(true);
	this.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		ComboChoice c = (ComboChoice)e.getSource();
		String selected = ((String)c.getSelectedItem()).trim();
		Debug.noteln("ComboChoice selection", selected);
		if (!c.hasItem(selected))
		    c.addItem(selected);
	    }
	});
    }

    public ComboChoice(Object[] items) {
	super(new DefaultComboBoxModel
	      (items.length > 0 ? items : new Object[]{""}));
    }

    public boolean hasItem(Object item) {
	for (int i = 0, count = getItemCount(); i < count; i++) {
	    if (getItemAt(i).equals(item))
		return true;
	}
	return false;
    }

    public String getSelectedString() {
	return ((String)getSelectedItem()).trim();
    }

    public void setSelectedItem(String item) {
//  	if (!hasItem(item))
//  	    addItem(item);
	super.setSelectedItem(item);
    }

}

