/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Dec 14 21:37:43 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.iface.util;

import javax.swing.*;

import ix.util.*;

/**
 * A JMenu that can insert items in alphabetical order.
 * To get a correctly ordered menu, the {@link #insert(JMenuItem)
 * insert(JMenuItem)} method should be used for all additions to
 * the menu.
 */
public class AlphabetizingMenu extends JMenu {

    public AlphabetizingMenu(String text) {
	super(text);
    }

    /**
     * Insert before the first item with lexicographically greater text.
     */
    public void insert(JMenuItem mi) {
	String text = mi.getText();
	int count = getItemCount();
	for (int i = 0; i < count; i++) {
	    JMenuItem item = getItem(i);
	    if (text.compareTo(item.getText()) < 0) {
		// Insert before the first item with text lexicographically
		// greater than the new item's.
		insert(mi, i);
		return;
	    }
	}
	// If no greater item was found, add at the end.
	add(mi);
    }

}
