/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Apr  2 04:15:22 2005 by Jeff Dalton
 * Copyright: (c) 2001 - 2005, AIAI, University of Edinburgh
 */

package ix.icore.process;

import java.util.*;

import ix.icore.Variable;
import ix.icore.Annotated;
import ix.icore.ConstraintManager;
import ix.icore.process.event.*;
import ix.icore.plan.*;

import ix.icore.domain.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;

// /\/: We still have to determine the right set of public methods.

public interface ProcessModelManager extends Annotated {

    public void reset();	// a complete reset that drops all contexts

    public void clear();	// a local, in-one-context reset.

    public void addVariable(Variable v);

    public Variable getVariable(Object name);

    public Map getVarEnv();  // public for ix.ip2.PlanMaker /\/

    public void addNode(PNode node);

    public List getNodes();

    // The plural add-constraint methods allow subclasses to have
    // only singular versions.

    public void addConstraints(PNode node, List constraints);

    public void addConstraints(List constraints);

    public void addConstraint(PNode node, Constraint c);

    // /\/: Not clear that this single-constrint version should be public
    public  void addConstraint(Constrainer constraint);

    // /\/: Very questionable.
    public void deleteConstraint(Constraint c);

    public List evalFilters(ListOfConstraint conds, MatchEnv env);

    public ListOfConstraint testFilters(ListOfConstraint conds, MatchEnv env);

    public ListOfConstraint getNodeConditions(PNode node);

    /* * * Constraint managers * * */

    public void registerConstraintManager
	          (Symbol type, Symbol relation, ConstraintManager cm);

    public ConstraintManager getConstraintManager(Symbol type, Symbol rel);

    public ConstraintManager getConstraintManager(Constraint c);

    /**
     * Tells the model manager to bind the indicated variables.
     * This is the only way in which values should ever be assigned.
     *
     * @see ix.icore.Variable
     */
    public void bindVariables(Map bindings);

    /**
     * Called by a node when its status changes.
     */
    public void statusChanged(PNode node);

    /**
     * Returns a copy of the pattern in which {@link ItemVar}s have
     * been replaced by {@link Variable}s.
     */
    public LList putVariablesInPattern(LList pattern);

    /*
     * State
     */

    public Plan getPlan();

    public void setPlan(Plan plan);

    /*
     * Listeners
     */

    public void addProcessStatusListener(ProcessStatusListener listener);

    public void fireStatusUpdate();

    public void fireNewBindings(Map bindings);

    public void fireStateChange(Map delta);

    public void fireStateDeletion(Map delta);

}
