/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Sep  4 01:29:40 2007 by Jeff Dalton
 * Copyright: (c) 2002, 2007, AIAI, University of Edinburgh
 */

package ix.icore.plan;

import java.util.*;

import ix.icore.*;
import ix.icore.domain.*;
import ix.util.*;
import ix.util.lisp.*;

/**
 * Introduces a {@link PlanVariable}.
 */
public class PlanVariableDeclaration extends PlanObject {

    protected Name id;
    protected Symbol name;		// really an ItemVar /\/
    protected VariableScope scope;

    // /\/: This is known when we construct a plan, but not when
    // a plan's read in from XML.
    protected PlanVariable planVariable;

    public PlanVariableDeclaration() {
    }

    public PlanVariableDeclaration(Name id, Variable v) {
	this.id = id;
	this.name = (Symbol)v.getName();
	this.scope = v.isGlobal()
	    ? VariableScope.GLOBAL
	    : VariableScope.LOCAL;
	this.planVariable = new PlanVariable(this.id, this.name);
    }

    public Name getId() {
        return id;
    }

    public void setId(Name id) {
        this.id = id;
    }

    public Symbol getName() {
        return name;
    }

    public void setName(Symbol name) {
        this.name = name;
    }

    public VariableScope getScope() {
	return scope;
    }

    public void setScope(VariableScope scope) {
	this.scope = scope;
    }

    public PlanVariable getPlanVariable() {
	// No set-method, so won't be included if translated to XML.
	return planVariable;
    }

    public String toString() {
	return "PlanVariableDeclaration[id=" + id + ", name=" + name
	    +  " " + scope + "]";
    }

}
