/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Jun  1 02:43:43 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.icore.log;

import org.jdom.Document;

import java.io.*;
import java.util.*;

import ix.iface.util.Reporting;

import ix.ip2.log.*; // bad modularity for this to know about that /\/

import ix.util.*;
import ix.util.xml.*;

// /\/: Should be packaged better.  There should be a class that
// can be used as a utility by things that want to process log files.

public class PrintEventLog {

    String logFileName;
    BufferedReader in;
    PrintStream out;

    public PrintEventLog() {
	this.out = System.out;
    }

    public static void main(String[] argv) throws Exception {
	Parameters.processCommandLineArguments(argv);
	new PrintEventLog().run();
    }

    void processCommandLineArguments() {
	logFileName = Parameters.getParameter("log");
    }

    void run() throws Exception {
	processCommandLineArguments();
	InputStream stream = new FileInputStream(logFileName);
	Reader streamReader = new InputStreamReader(stream, "UTF-8");
	in = new BufferedReader(streamReader);
	while (true) {
	    String block = readBlock(in);
	    if (block == null)
		break;
	    block = block.trim();
	    if (block.equals(""))
		continue;
	    HistoryEvent event = (HistoryEvent)XML.objectFromXML(block);
	    describeEvent(event);
	    out.println("- - - - - - - - - -");
	}
    }

    String readBlock(BufferedReader in) {
	String line = readLine();
	if (line == null)
	    return null;
	StringBuffer result = new StringBuffer();
	while (true) {
	    result.append(line);
	    result.append("\n");
	    line = readLine();
	    if (line == null)
		break;
	    if (line.startsWith("</")) {
		result.append(line);
		result.append("\n");
		break;
	    }
	}
	return result.toString();
    }

    String readLine() {
	try {
	    return in.readLine();
	}
	catch (IOException e) {
	    Debug.displayException(e);
	    return null;
	}
    }

    void describeEvent(HistoryEvent event) {
	out.println(event.getDate() + " " + eventClassName(event));
	if (event instanceof HistoryComment)
	    describeEvent((HistoryComment)event);
	else if (event instanceof MessageSent)
	    describeEvent((MessageSent)event);
	else if (event instanceof MessageReceived)
	    describeEvent((MessageReceived)event);
	else if (event instanceof ItemHandledEvent)
	    describeEvent((ItemHandledEvent)event);
	else if (event instanceof BindingEvent)
	    describeEvent((BindingEvent)event);
    }

    String eventClassName(HistoryEvent event) {
	return Strings.afterLast(".", event.getClass().getName());
    }

    void describeEvent(HistoryComment event) {
	out.println(" " + event.getContents());
    }

    void describeEvent(MessageSent event) {
	out.println(" " + Reporting.description(event.getContents()));
    }

    void describeEvent(MessageReceived event) {
	out.println(" " + Reporting.description(event.getContents()));
    }

    void describeEvent(ItemHandledEvent event) {
	out.println(" " + event.getPattern());
	out.println(" " + event.getAction());
    }

    void describeEvent(BindingEvent event) {
	out.println(" " + event.getBindings());
    }

}
