/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon May 19 19:13:54 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.icore.event;

import java.util.EventObject;

public class AnnotationEvent extends EventObject {

    Object key;
    Object value;

    public AnnotationEvent(Object source, Object key, Object value) {
	super(source);
	this.key = key;
	this.value = value;
    }

    public Object getKey() { return key; }

    public Object getValue() { return value; }

    public boolean isDeletion() { return value == null; }

    public String toString() {
	return "AnnotationEvent[source=" + source +
	    ", key=" + key + ", value=" + value + "]";
    }

}
