/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Apr 14 14:45:21 2005 by Jeff Dalton
 * Copyright: (c) 2002, 2004, AIAI, University of Edinburgh
 */

package ix.icore.domain;

import java.io.Serializable;
import java.util.*;

import ix.util.*;

public class NodeEndRef implements Serializable {

    public static final Name SELF = Name.valueOf(":self");

    protected End end;
    protected Name node;

    public NodeEndRef() {
    }

    public NodeEndRef(End end, Name node) {
	this.end = end;
	this.node = node;
    }

    public NodeEndRef(End end, String node) {
	this.end = end;
	this.node = Name.valueOf(node);
    }

    public End getEnd() { return end; }
    public void setEnd(End end) { this.end = end; }

    public Name getNode() { return node; }
    public void setNode(Name node) { this.node = node; }

    public boolean equals(Object obj) {
	if (obj instanceof NodeEndRef) {
	    NodeEndRef nref = (NodeEndRef)obj;
	    return end == nref.end && node.equals(nref.node);
	}
	else return false;
    }

    public boolean isToSelf() {
	return node.equals(SELF);
    }

    public int hashCode() {
	return 31 * end.hashCode() + node.hashCode();
    }

    public String toString() {
	return "NodeEndRef[" + end + "_of " + node + "]";
    }

}

// Issues:
// * Maybe call the node field nodeId.
