/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Feb  7 15:28:50 2002 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.icore.domain;

import java.util.*;
import ix.util.*;

/**
 * Used to specify the begin or end of a node in a NodeEndRef.
 *
 * @see NodeEndRef
 */
public final class End extends EnumeratedValue {

    private static List values = new LinkedList();

    private End() { }

    private End(String name) {
	this.name = name;
	recordValue(values, this);
    }	

    public static final End
	BEGIN = new End("begin"),
	END   = new End("end");

    public String toString() {
	return name;
    }

    public static List values() {
	return Collections.unmodifiableList(values);
    }

    public static End valueOf(String name) {
	return (End)getValueElseError(values, name);
    }

}


