/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Aug 16 20:07:09 2002 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.icore;

import java.awt.Color;
import java.util.*;
import ix.util.*;

/**
 * Priority values.
 */
public final class Priority extends EnumeratedValue implements Comparable {

    private static List values = new LinkedList();

    private Color color;

    private Priority() { }

    private Priority(String name, int colorRGB) {
	this.name = name;
	this.color = new Color(colorRGB);
	recordValue(values, this);
    }	

    public static final Priority
	LOWEST  = new Priority("lowest",  0x9999ff),
	LOW     = new Priority("low",     0xccccff),
	NORMAL  = new Priority("normal",  0xffffff),
	HIGH    = new Priority("high",    0xffcccc),
	HIGHEST = new Priority("highest", 0xff6699);

    public Color getColor() {
	return color;
    }

    public int compareTo(Object o) {
	if (o instanceof Priority)
	    return values.indexOf(this) - values.indexOf(o);
	else
	    throw new ClassCastException
		("Cannot compare priority " + this + " to " + o);
    }

    public String toString() {
	return name;
    }

    public static List values() {
	return Collections.unmodifiableList(values);
    }

    public static Priority valueOf(String name) {
	return (Priority)getValueElseError(values, name);
    }

}


