/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Apr 25 21:35:53 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2006, AIAI, University of Edinburgh
 */

package ix.ichat;

import ix.icore.*;

import ix.ichat.ChatMessage;

import ix.util.*;


/** 
 * A class for I-Chat as a standalone application main program 
 */

public class IChat extends IXAgent {

    ChatFrame frame;

    public IChat() {
    }

    /**
     * Main program.
     */
    public static void main(String[] argv) {
	Util.printGreeting("I-Chat");
	new IChat().mainStartup(argv);
    }

    /**
     * Command-line argument processing for arguments used by all
     * versions of I-Chat.
     */
    protected void processCommandLineArguments() {
	super.processCommandLineArguments();
    }

    /**
     * Completes I-Chat setup and initialization.
     */
    public void startup() {
	frame = new ChatFrame(this, displayName);
	frame.setVisible(true);
    }

    /**
     * Handles new chat messages.
     */
    public void handleNewChatMessage(ChatMessage message) {
	frame.newMessage(message);
    }


}
