/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Mar 18 02:59:38 2006 by Jeff Dalton
 * Copyright: (c) 2001, 2002, 2006, AIAI, University of Edinburgh
 */

package ix.ichat;

import java.io.Serializable;
import java.util.*;

import ix.icore.Sendable;
import ix.icore.AbstractAnnotatedObject;
import ix.util.*;
import ix.util.lisp.*;

/**
 * A frame for chat dialogues.
 */
public class ChatMessage extends AbstractAnnotatedObject
                         implements Serializable, Cloneable, Sendable {

    // /\/: Should we extend AbstractIXObject instead?

    protected String text;
    protected Name senderId;

    public ChatMessage() {
    }

    public ChatMessage(String text, String senderId) {
	this.text = text;
	this.senderId = Name.valueOf(senderId);
    }

    public String getText() {
	return text;
    }

    public void setText(String text) {
	this.text = text;
    }

    public Name getSenderId() {
	return senderId;
    }

    public void setSenderId(Name id) {
	this.senderId = id;
    }

    public Object clone() throws CloneNotSupportedException {
	return super.clone();
    }

}
