/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Mar 19 20:23:11 2005 by Jeff Dalton
 * Copyright: (c) 2000, 2005, AIAI, University of Edinburgh
 */

package ix.examples;

import java.util.*;

import ix.util.*;
import ix.util.lisp.*;


/**
 * A simple example using an I-X framework.  This example shows how
 * to extend PicoISim to create a simulator.
 */

public class PicoISimTest1 extends PicoISim {

    /**
     * Main program.
     */
    public static void main(String[] argv) {

	IX_Simulator sim = new IX_Simulator();

	sim.addSimEventHandlers(makeTestSimEventHandlers());

	sim.setListener(new IX_SystemListener());

	sim.schedule(new SimEvent("return", "foo", 100));
	sim.schedule(new SimEvent("return", "pre-foo", 10));

	sim.start();

    }

    static Object[] makeTestSimEventHandlers() {
	return new Object[] {

	    new SimEventHandler("return") {
		void handleActivity(Activity i) {
		    system.notifyListener(i.object);
		}
	    }

	};

    }

}

