/****************************************************************************
 * A simple node name renderer for list or table cells.
 *
 * @author Jussi Stader
 * @version 2.0
 * Updated: Mon Jan 22 09:59:40 2007
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview.util;

import java.util.Iterator;
import java.util.List;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;

import ix.util.Name;
import ix.util.lisp.*;
import ix.iface.ui.*;
import ix.icore.domain.NodeSpec;
import ix.iview.domain.UIRefinement;

/****************************************************************************
 * A simple node name renderer for list or table cells.
 *****************************************************************************
 */
public class NodeNameRenderer extends IXLabelRenderer {//IXTextRenderer
  /** 
   * Creates a node name renderer with/without a border.
   * @param isBordered - flag that determines whether to put a border around
   * the cell to show selection status
   */
  public NodeNameRenderer(boolean isBordered) {super(isBordered);}
  /**
   * Sets the cell text to the node name e.g. "alter plan"
   */
  public void setInfo(Object object){
    setText(makeText(object));
  }
  public static String makeText(Object object) {
    if (object == null) return "";
    else if (object instanceof UIRefinement) 
      return "self (" + ((UIRefinement)object).getName() + ")";
    else if ((object instanceof LList) || (object instanceof NodeSpec)) {
      List pattern = Lisp.NIL;
      if (object instanceof LList) {
	LList list = (LList)object;
	pattern = (LList)list.elementAt(1);
      }
      else if (object instanceof NodeSpec)
	pattern = ((NodeSpec)object).getPattern();
      String text = "";
      for (Iterator i = pattern.iterator(); i.hasNext();) {
	Object o = i.next();
	  if (o != null) text = text + o.toString() + " ";
      }
      return text;
    }
    //else if (object instanceof Symbol) return object.toString();
    else return object.toString();
  }

}

