/****************************************************************************
 * A TreeModel that can display Refinement of a domain.
 *
 * @author Jussi Stader
 * @version 2.0
 * Updated: Mon Jan 29 10:57:39 2007
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iview.tree;

import java.util.*;
import javax.swing.*;
import javax.swing.tree.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.icore.domain.*;
import ix.icore.*;
import ix.iview.domain.*;
import ix.iface.ui.tree.*;
import ix.iface.ui.util.*;


public class RefinementTreeModel extends DomainTreeModel {
    

  /**
   * Constructs a new instance with the given node as the root node
   * of the tree.
   * @param domain The UIDomain for this model.
   * @param root The root node of the tree model.  
   */
  public RefinementTreeModel(UIDomain domain, IXTreeNode root) {
    super(domain, root);
  }
  
  public IXTreeNode newIXTreeNode(Object userObject) {
    //Debug.noteln("Making tree node for", userObject);
    RefinementTreeNode node = null;
    try {
      node = new RefinementTreeNode((Refinement) userObject);
    }
    catch (ClassCastException e) {
      try {
	node = new RefinementTreeNode((UIRefinement) userObject);
	
      }
      catch (ClassCastException e2) {
	Debug.noteln("RefTM: cannot make refinement tree from class",
		     userObject.getClass());
      }
    }
    return node;
  }


  public List findUserObjects() { 
    if (uiDomain == null) return null;
    else return uiDomain.getAllRefinements();
  }
  public Object findUserNode(String name) { 
    if (uiDomain == null) return null;
    else return uiDomain.getNamedRefinement(name);
  }
  public Object makeUserObject(String name) {
    UIRefinement uir = new UIRefinement(uiDomain);
    uir.setName(name);
    return uir;
  }
  //refinements have no parents! children are node specs
  public Object makeUserObject(String name, List children) {
    UIRefinement uir = (UIRefinement)makeUserObject(name);
    for (Iterator i = children.iterator(); i.hasNext(); ) {
      Object child = i.next();
      if (child instanceof NodeSpec)
	uir.addNode((NodeSpec)child);
    }
    return uir;
  }

  public boolean isOwnUserObject(Object object) {
    return (object instanceof UIRefinement);
  }
 
  public List getUserChildren(Object userParent) {
    try {
      return Collections.list(((UIRefinement)userParent).children());
    }
    catch (Exception e) {
      Debug.noteException(e);
      return null;
    }
  }
  public void addUserChild(Object userParent, Object newChild) {
    if (newChild instanceof NodeSpec) {
      ((UIRefinement)userParent).addNode((NodeSpec)newChild);
    }
  }
  public void removeUserChild(Object userParent, Object newChild) {
    if (newChild instanceof NodeSpec) {
      ((UIRefinement)userParent).deleteNode((NodeSpec)newChild);
    }
  }


  public List getUserParents(Object userObject) {
    return null;
  }
  public void addUserParent(Object userObject, Object newParent) {
    
  }
  public void removeUserParent(Object userObject, Object oldParent) {
  }

}
