/****************************************************************************
 * A TreeModel that can display ObjectClass objects of a domain.
 *
 * @author Jussi Stader
 * @version 2.0
 * Updated: Thu Sep 28 10:28:58 2006
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */

package ix.iview.tree;

import java.util.*;
import javax.swing.*;
import javax.swing.tree.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.icore.domain.*;
import ix.icore.*;
import ix.iview.util.*;
import ix.iview.domain.*;
import ix.iface.ui.tree.*;
import ix.iface.ui.util.*;


public class ObjectClassTreeModel extends DomainTreeModel {


  /**
   * Constructs a new instance with the given node as the root node
   * of the tree.
   * @param domain The UIDomain for this model.
   * @param root The root node of the tree model.  
   */
  public ObjectClassTreeModel(UIDomain domain, IXTreeNode root) {
    super(domain, root);
  }
  
  public IXTreeNode newIXTreeNode(Object userObject) {
    ObjectClassTreeNode node = null;
    try { node = new ObjectClassTreeNode((ObjectClass) userObject); }
    catch (ClassCastException e) {
      try { node = new ObjectClassTreeNode((UIObjectClass) userObject); }
      catch (ClassCastException e2) {
	Debug.noteln("OcTM: cannot make objectClass tree from class",
		     userObject.getClass());
      }
    }
    return node;
  }
  

  public List findUserObjects() { 
    if (uiDomain == null) {
      Debug.noteln("OCTreeModel has no domain");
      return null;
    }
    else return uiDomain.getAllObjectClasses();
  }

  public Object findUserNode(String name) { 
    if (uiDomain == null) {
      Debug.noteln("OCTreeModel has no domain");
      return null;
    }
    else return uiDomain.getNamedObjectClass(name);
  }
  public Object makeUserObject(String name) {
    UIObjectClass uioc = new UIObjectClass(uiDomain, name);
    return uioc;
  }
  public Object makeUserObject(String name, List children) {
    UIObjectClass uioc = (UIObjectClass)makeUserObject(name);
    for (Iterator i = children.iterator(); i.hasNext(); ) {
      String child = IVUtil.getRelativeName(i.next());
      if (child != null) uioc.addChild(child);
    }
    return uioc;
  }

  public boolean isOwnUserObject(Object object) {
    return (object instanceof UIObjectClass);
  }
 
  public List getUserChildren(Object userParent) {
      //Debug.noteln("OCTMod: getting user children for ", userParent);
    try {
      Enumeration children = ((UIObjectClass)userParent).children();
      //Debug.noteln("  got children", UIUtil.show(children));
      List kids = Collections.list(children);
      //List kids = UIUtil.enumerationToList(children);
      //Debug.noteln("  got children list", UIUtil.show(kids));
      return kids;
    }
    catch (Exception e) {
      Debug.noteException(e);
      return null;
    }
  }
  public void addUserChild(Object userParent, Object newChild) {
    if (userParent instanceof UIObjectClass) {
      String child = IVUtil.getRelativeName(newChild);
      if (child != null) 
	((UIObjectClass)userParent).addChild(child);
    }
    else {
      Debug.noteln("UCTreeMod: cannot add children to ObjectClass directly");
    }
  }
  public void removeUserChild(Object userParent, Object oldChild) {
    if (userParent instanceof UIObjectClass) {
      String child = IVUtil.getRelativeName(oldChild);
      if (child != null) 
	((UIObjectClass)userParent).removeChild(child);
    }
    else {
      Debug.noteln("UCTreeMod: cannot remove children from ObjectClass");
    }
  }

  public List getUserParents(Object userObject) {
    try {
      List parents = ((UIObjectClass)userObject).getParents();
      return parents;
    }
    catch (Exception e) {
      Debug.noteException(e);
      return null;
    }
  }
  /**
   * Can only deal with UIObjectClass arguments
   */
  public void addUserParent(Object object, Object parent) {
    if ((object instanceof UIObjectClass) && 
	(parent instanceof UIObjectClass)) {
      if (parent != null) 
	((UIObjectClass)object).addParent((UIObjectClass)parent);
    }
    else {
      Debug.noteln("OCTreeMod: cannot only add parents with UIObjectClasses");
      Debug.noteln(" found " + object.getClass() + 
		   " and " + parent.getClass());
    }
  }
  public void removeUserParent(Object userObject, Object oldParent) {
    if (userObject instanceof UIObjectClass) {
      String parent = IVUtil.getRelativeName(oldParent);
      if (parent != null) 
	((UIObjectClass)userObject).removeParent(parent);
    }
    else {
      Debug.noteln("UCTreeMod: cannot remove parent from ObjectClass");
    }
  }


}
