/* Author: Jussi Stader
 * Date: 6/2/02
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.iview.domain.event;

import java.util.*;
import ix.iview.domain.*;
import ix.icore.domain.event.*;

public interface UIDomainListener extends EventListener {
  /** 
   * Called when a UI construct is added. 
   * Use getSource() to get at the domain (UI/IX) in which the event occurred.
   * Use getObject() to get at the object (UI/IX) that has been added.
   */
  public void constructAdded(UIDomainEvent event);
  public void constructAdded(DomainEvent event);
  /** 
   * Called when a UI construct is edited. 
   * Use getSource() to get at the UIDomain in which the event occurred.
   * Use getObject() to get at the UIObject that has been edited.
   */
  public void constructEdited(UIDomainEvent event);
  /** 
   * Called when a UI construct is removed. 
   * Use getSource() to get at the UIDomain in which the event occurred.
   * Use getObject() to get at the UIObject that has been removed.
   */
  public void constructRemoved(UIDomainEvent event);
  /** Called when the domain's own fields changed (currently only name). */
  public void domainEdited(UIDomainEvent event);
  /** Called when the domain is cleared. */
  public void domainCleared(UIDomainEvent event);

  /** Called when the domain is added. */
  public void domainSet(UIDomainEvent event);
}
