/****************************************************************************
 * An editor/viewer panel for the domain itself (global information)
 *
 * @author Jussi Stader
 * @version 4.1
 * Updated: Mon Mar 19 13:25:09 2007
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview;

import java.lang.Math;
import java.lang.reflect.*;
import java.util.*;
import javax.swing.*;       
import javax.swing.tree.*;
//import java.awt.*;
import java.awt.Component;
import java.awt.event.*;
import ix.*;
import ix.util.TextAreaFrame;
import ix.util.Debug;
import ix.util.Util;
import ix.util.lisp.*;
import ix.icore.*;
import ix.icore.domain.*;
import ix.icore.domain.event.*;
import ix.iface.ui.*;
import ix.iface.ui.table.*;
import ix.iface.ui.util.*;
import ix.iface.domain.*;
import ix.iview.event.*;
import ix.iview.table.*;
import ix.iview.domain.*;
import ix.iview.domain.event.*;

/****************************************************************************
 * An editor/viewer panel for the domain itself (global information)
 *
 * Example code for using the GlobalFramePanel:
 *<PRE><code>
 *    ...
 *    domainPanel = new GlobalFramePanel(this);
 *    mainJPanel.add(domainPanel); 
 *    ...
 *</code></PRE>
 *****************************************************************************
 */
public class GlobalFramePanel extends AConstructFramePanel 
  implements CurrentActionListener
{

  //---------------------Fields-------------------------------------------


  //---------------------Constructors----------------------------------------

  /**
   * Creates a construct frame panel with the given parent,
   * Creates all panel components, the mouse listener, and the relation editor.
   *
   * @param parent the DomainEditor frame that the panel belons to. Used 
   *   mainly to keep toggle buttons and menus in synch
   */    
  public GlobalFramePanel(){
    super();
  }
  public GlobalFramePanel(DomainEditorFrame theParent){
    //make all things (some are made during initialisation)
    super(theParent);
    IFormModel model = new DomainFormModel();
    String[] fields = {"refinements", "objectClasses", "comments"}; 
    //, "annotations"
    model.setDisplayFields(fields);
    //formPanel.setModel(model, this);
    formPanel.setModel(model);
    formPanel.addFormActionListener(this);

    hasOverview = true;
    setSort(DEFAULT_SORT);
    UIDomain uid = parent.getUIDomain();
    setUIConstruct(uid);
    uid.addUIDomainListener((GlobalFormPanel)formPanel);
  }
 

  protected JPanel setupMainPanel() {
    formPanel = new GlobalFormPanel(this);
    //Debug.noteln("made global form panel for GFrP");
    return formPanel;
  }

  //---------------------Field access----------------------------------------

  
  //---------------------Toggles----------------------------------------


  //---------------------Window building-------------------------------------


  //---------------------Public services--------------------------------------


  protected UIObject cloneConstruct(UIObject uiConstruct) {
    return null;
  }

  /**
   * Sets the construct's fields in their respective panels (fills the panels).
   */
  protected void setConstructFields() {
    
  }
  public List getAllConstructs() {
    return null;
    /*  this old stuff makes a useless "Edit Domain" menu appear
    List al = new LListCollector();
    al.add(parent.getUIDomain());
    return al;
    */
  }
  public void newConstruct() {
    //parent.getUIDomain().setNewDomain(parent.getUIDomain().getDomain());
    notImp("Creating a new domain");
  }
  public UIObject makeNewConstruct() {
    return new UIDomain(parent.editor());
  }
  public boolean checkConstruct(){
    try {
      if (parent.getUIDomain() != null) 
	//parent.getUIDomain().checkConsistency();
	parent.getUIDomain().checkAndReportConsistency();
      return true;
    }
    catch (SyntaxException se) {
      JOptionPane.showMessageDialog(this, se.getMessage());
      return false;
    }
  }
  public void viewChanges() {
      UIDomain uiConstruct = parent.getUIDomain();
      if (uiConstruct == null) 
	  JOptionPane.showMessageDialog(this,"No construct to check");
      else {
	  List changes = uiConstruct.collectChanges();
	  if ((changes == null) || (changes.size() == 0))
	      JOptionPane.showMessageDialog(this,"No changes found");
	  else {
	      TextAreaFrame taf = new 
		  TextAreaFrame("Changes for " + uiConstruct.getName());
	      for (Iterator i=changes.iterator(); i.hasNext();)
		  taf.appendLine((String)i.next());
	      taf.setVisible(true);
	  }
      }
  }
  public void viewChangesFromOriginal() {
      UIDomain uiConstruct = parent.getUIDomain();
      if (uiConstruct == null) 
	  JOptionPane.showMessageDialog(this,"No construct to check");
      else {
	  List changes = uiConstruct.collectChangesFromOriginal();
	  if ((changes == null) || (changes.size() == 0))
	      JOptionPane.showMessageDialog(this,"No changes found");
	  else {
	      TextAreaFrame taf = new 
		  TextAreaFrame("Changes for " + uiConstruct.getName());
	      for (Iterator i=changes.iterator(); i.hasNext();)
		  taf.appendLine((String)i.next());
	      taf.setVisible(true);
	  }
      }
  }
  /**
   * User request to save a domain.
   */
  public void saveConstruct(){
    noteConstruct();
    //parent.userSaveDomain();
  }

  /**
   * User request to revert an action to when it was last saved in 
   * the draft domain.
   */
  public void revertConstruct(){
    UIDomain uid = parent.getUIDomain();
    uid.loadFromDomain();
    setUIConstruct(uid);
  }
  /**
   * User request to revert an action to when it was last saved in 
   * the draft domain.
   */
  public void revertOConstruct(){
    UIDomain uid = parent.getUIDomain();
    uid.loadFromOriginal();
    setUIConstruct(uid);
  }

  protected UIObject noteConstruct() {
    //make sure there is a current construct
    UIDomain uid = parent.getUIDomain();
    //Debug.note("GFrP: saving domain name " + uid.getName());
    formPanel.saveToObject(uid);
    Debug.noteln(" new name:", uid.getName());
    uid.saveToDomain();
    setUIConstruct(uid);
    return uid;
  }

  public Named getNamedConstruct(String name) {
    //Debug.noteln("Getting named domain " + name);
    if (parent.getUIDomain() == null) return null;
    else if (parent.getUIDomain().getName().equals(name)) 
      return parent.getUIDomain();
    else return null;
  }


  //default uses newConstruct which in this case calls userClearDomain (loops!)
  public void clear() {
    parent.getUIDomain().clear();
    refresh();
  }

  public void refresh() {
    setUIConstruct(parent.getUIDomain());
  }

  public void setSort(boolean sortIt) {
    ((GlobalFormPanel)formPanel).setSort(sortIt);
  }
  public boolean getSort() {return ((GlobalFormPanel)formPanel).getSort();}

  public void userDeclareVariables() {
    Debug.noteln("GFP: Declaring variables in domain",parent.getUIDomain());
    parent.getUIDomain().declareAllVariables();
    //Debug.noteln("  declared them all");
  }

  public void userFindVariables() {
    //Debug.noteln("GFP: Finding variables in domain",parent.getUIDomain());
    UIDomain uid = parent.getUIDomain();
    Set vars = uid.findVariablesUsed();
    if ((vars == null) || (vars.size() == 0)) 
      JOptionPane.showMessageDialog(this,"No variables used");
    else {
      Object[] used = vars.toArray();
      String[] v = {"The refinements in the domain " + uid.getName() + 
		    " use the variables listed below",
		    "To find refinements that use a listed variable" + 
		    " select it in the list and click ok."};
      Object todo = 
	JOptionPane.showInputDialog(parent, v, "Variables Used",
				    JOptionPane.INFORMATION_MESSAGE, null,
				    used, used[0]);
      if ((todo != null) && (todo != "")) {
	Collection users = uid.findVariableUsers((ItemVar)todo);
	if ((users == null) || (users.size() == 0))
	  JOptionPane.showMessageDialog(this,"Cannot find refinements using"
					+ todo);
	else {
	  try {
	    Object[] usersA = users.toArray();
	    String[] u = {"The refinements in the domain " + uid.getName() + 
			  " that use variable " + todo + " are listed below",
			  "To go straight to editing a listed refinement,",
			  " select it in the list and click ok."};
	    Object todo2 = 
	      JOptionPane.showInputDialog(parent, u, "Refinements Using" + 
					  todo,JOptionPane.INFORMATION_MESSAGE,
					  null, usersA, usersA[0]);
	    if (todo2 != null) {
	      Refinement refinement = (Refinement)todo2;
	      parent.editor().setConstruct(refinement);
	    }
	  }
	  catch (Exception e) {
	    Debug.noteException(e);
	  }
	}
      }
    }
  }


  private void userDeleteItem(IXEditorPanel edPan) {
    //Debug.noteln("GlFoP: user delete item");
    List objects = getClearSelection(edPan);
    //delete the refinement from the UIDomain
    if (objects != null) {
      for (Iterator i = objects.iterator(); i.hasNext(); ){
	Object item = i.next();
	try { getUIDomain().removeConstruct((UIObject)item); }
	catch (ClassCastException ce) { 
	  try { getUIDomain().removeConstruct((Named)item); }
	  catch (ClassCastException e) { 
	    Debug.noteln("Domain Editor: Cannot delete things of class", 
			 item.getClass().getName());
	    //Debug.noteException(e);
	  }
	}
      }
    }
  }

  private void userEditItem(IXEditorPanel edPan) {
    List selections = getClearSelection(edPan);
    if ((selections != null) && !selections.isEmpty()) {
      //just pick the first selection
      Object selection = selections.get(0);
      //show the right EditorPanel via parent, setConstruct on the panel
      try { getEditor().setConstruct((IXObject)selection); }
      catch (ClassCastException xe) { 
	Debug.noteln("GFrP: not ix - trying ui"); 
	try { getEditor().setUIConstruct((UIObject)selection); }
	catch (ClassCastException ue) { 
	  Debug.noteln("GFrP: not ix or ui - trying nodeSpec");
	  try { 
	    UINodeSpec node = (UINodeSpec)selection;
	    UIRefinement uir = new UIRefinement(getUIDomain());
	    uir.setPattern(node.getPattern());
	    if (uir.getName() == null) uir.setName("undefined");
	    getEditor().setUIConstruct(uir); 
	  }
	  catch (ClassCastException ne) { 

	    Debug.noteln("Domain Editor: Cannot edit things of class", 
			 selection.getClass().getName());
	    //Debug.noteException(ne);
	  }
	}
      }
    }
  }

  private DomainEditor getEditor() { return parent.editor(); }

  private List getClearSelection(IXEditorPanel edPan) {
    Component component =  edPan.getItemComponent();
    if (component instanceof IXTreeTable) {
      IXTreeTable table = (IXTreeTable)component;
      int[] rowNos = table.getSelectedRows();
      table.clearSelection();
      if (rowNos.length == 0) {
	complainNoSelection(edPan); 
	return null;
      }
      else {
	List selections = new ArrayList();
	AbstractIXTableModel model = (AbstractIXTableModel)table.getModel();
	for (int i = 0; i < rowNos.length; i++) {
	  selections.add(model.getRowObject(rowNos[i]));
	}
	return selections;
      }
    }
    else if (component instanceof JList) {
      List selections = Arrays.asList(((JList)component).getSelectedValues());
      ((JList)component).clearSelection();
      if ((selections == null) || selections.isEmpty()) {
	complainNoSelection(edPan);
	return null;
      }
      else return selections;
    }
    return null;
  }

  private void complainNoSelection(IXEditorPanel edPan) {
    String message = "Please select an item from the list first.";
    JOptionPane.showMessageDialog(this.parent, message);
  }



  //-------------------Protected services--------------------------------------


  //----------------------Listener things--------------------------------------
  
  public void addCurrentActionListener(CurrentActionListener cal) {
    ((GlobalFormPanel)formPanel).addCurrentActionListener(cal);
  }

  public void actionChanged(Component source, 
			    UIRefinement old, UIRefinement newAction) {
    //Debug.noteln("GFP: action changed to", newAction);
    if (this.equals(source)) return;
    else {
      ((GlobalFormPanel)formPanel).reactingActionChange(true);
      ((GlobalFormPanel)formPanel).setSelectedAction(newAction);
      ((GlobalFormPanel)formPanel).reactingActionChange(false);
    }
  }


  //----------------------Action services--------------------------------------
  


  public boolean frameActionPerformed(ActionEvent event){
    String command = event.getActionCommand();
    Debug.noteln("DomainFramePanel got frame action command", command);
    if (command == "newConstruct") newConstruct();
    else if (command == "editConstruct") {
      //get the construct name from the item text and show it
      JMenuItem item = (JMenuItem)event.getSource();
      String name = item.getText().trim();
      setUIConstruct((UIObject)getNamedConstruct(name));  
    }
    else if (command == "modify") saveConstruct();
    else if (command == "revert") revertConstruct();
    else if (command == "revertO") revertOConstruct();
    else if (command == "check") checkConstruct();
    else if (command == "declareVars") userDeclareVariables();
    else if (command == "findVars") userFindVariables();
    else return false;
    return true;
  }
  /**
   * Wakes up the ActionListener with a user action.
   * This is called when a KeyStroke happens in which the ActionListener
   * registered its interest.
   */
  public void actionPerformed(ActionEvent ae){
    String command = ae.getActionCommand();
    //Debug.noteln("Global Domain Panel got action command", command);
    if (frameActionPerformed(ae)) return;
    else if (buttonActionPerformed(ae)) return;
    else Debug.noteln("GlobalFramePanel cannot recognise command", command);
  }

  private boolean buttonActionPerformed(ActionEvent ae) {
    IXEditorPanel buttonParent = UIUtil.getEventPanel(ae);
    if (buttonParent == null) return false;  //----->
    String parentName = buttonParent.getName();
    if (parentName == null) return false;    //----->
    String command = ae.getActionCommand();
    if (command == null) return false;       //-----> 
    Debug.noteln("Global Domain Panel got button action command", command);

    if (command.equals("Delete")) {
	userDeleteItem(buttonParent);
	return true;
    }
    else if (command.equals("Edit")) {
	userEditItem(buttonParent);
	return true;
    }
    else if (parentName.equals("ObjectClasses")) {
      if (command.equals("Add")) {
	  String message = 
	    "Please use the Objects panel to add object classes."; 
	  JOptionPane.showMessageDialog(null, message);
      }
      else {
	UIUtil.notImplemented(null, command + " for object classes");
	return false;
      }
      return true;
    }
    else if (parentName.equals("Refinements")) {
      if (command.equals("Add")) {
	getEditor().setConstruct(new Refinement());
      }
      else {
	UIUtil.notImplemented(null, command + " for refinements");
	return false;
      }
      return true;
    }
    else {
      UIUtil.notImplemented(null, "Command " + command);
      return false;
    }
  }

  protected void notImp(String message) {
    UIUtil.notImplemented(this,message);
  }

}

/*Issues***************************************************************
 *
 *
/*Todos***************************************************************
 *
 * - finish off displaying object classes
 *  
 *****************************************************************************
 */
