/****************************************************************************
 * A renderer that can follow URL links
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

// needs class TwoField in ix.iface

import javax.swing.*;//jtable, list cell renderer etc
import ix.*;
import ix.util.Debug;
import ix.iface.util.*;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;


/****************************************************************************
 * A renderer that can follow URL links.
 * 
 * Expects to use a TwoField, ThreeField or FourField object to obtain up
 * to four values, which are represented using text, colour, an image and a 
 * symbol.<p>
 *
 * The IXLabelRenderer is created with a boolean argument which determines whether
 * the cell has a border or not. The border is used to show whether the
 * cell/row is selected or not.<p>
 *
 * The fields unselectedBorder, selectedBorder, and isBordered are
 * used to handle the borders of the cell if it has one.
 *
 * The class sub-classes RendererJLabel rather than JLabel for performance
 * reasons (see Java API documentation of TableCellRenderer or 
 * ListCellRenderer for more detail).
 *
 ****************************************************************************
 */
public class RendererLinkLabel extends RendererJLabel 
{ 
  public RendererLinkLabel() {    }

  protected URL link = null;
  protected HTMLFrame linkDisplay = null;

  public boolean isLink() {
    return (link != null);
  }
  public boolean linkEnabled() {
    return (linkDisplay != null);
  }

  public void enableLink(HTMLFrame linkFrame) {
    linkDisplay = linkFrame;
    this.addMouseListener(new MouseAdapter() {
	public void mouseClicked(MouseEvent me) {
	  if (RendererLinkLabel.this.linkEnabled() && 
	      RendererLinkLabel.this.isLink()) {
	    //try to follow link
	    linkDisplay.displayURL(link);
	    linkDisplay.setVisible(true);
	  }
	}
      });
			  
  }
  public void disableLink() {
    linkDisplay = null;
  }
  public void setText(String txt) {
    link = null;
    if (linkEnabled()) {
      try {
	URL link = new URL(txt);
      }
      catch (Exception e) {
	//Debug.noteln("setting label text in RendLinkLab");
	//Debug.noteException(e);
      }
    }
    super.setText(txt);
  }


}

