/****************************************************************************
 * A JComboBox that generates an event even when the same item is selected.
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import ix.util.*;
import ix.iface.ui.*;

import java.awt.event.*;
//import java.awt.Component;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;

  /**
   * A JComboBox that generates an event even when the same item is selected.
   * Call clearSelectedItem() before bringing it up.
   */
public class IXComboBox extends JComboBox {
  public IXComboBox() {
    super();
  }
  public void hidePopup() {
    //Debug.noteln("***HA: hiding box");
    super.hidePopup();
  }

  /**
   * This is a hack to make sure the box generates an event (that can be
   * detected by a table cell) if the same item is selected again.
   */
  public void clearSelectedItem() { selectedItemReminder = "";}
}
