/* Author: Jussi Stader <J.Stader@ed.ac.uk>
 * Updated: Mon Jul 3 2001 by Jussi Stader
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.iface.ui;

import java.awt.event.ActionEvent;

/**
 * An interface implemented by all panels that may handle events generated
 * in their parent frames.
 */
public interface FramePanel {
  /**
   * Should recognise panel specific events and processes them.
   * This is a separate method from the normal actionPerformed because
   * it is called by other event handlers and must let them know whether
   * it recognised the event.
   *
   * @param event the event to be processed.
   * @return true if the event was recognised, false if not.
   */
  public boolean frameActionPerformed(ActionEvent event);
}

// Issues:
