/****************************************************************************
 * An interface for objects to be edited, especially via IForm editors
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Mon Jun 30 16:41:47 2003
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import ix.*;
import ix.util.Debug;
import ix.util.lisp.*;
import ix.iface.ui.event.*;

import java.lang.reflect.*;
//import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * An interface for objects to be edited, especially via IForm editors
 *
 */
public interface EditableObject {

  //public void setValue(String field, Object value);
  //public List getFields();
  //public Object getValue(String field);
  /**
   * Sets the given field to the given value. Should default to 
   * UIUtil.setObjectFieldValue(Object object, String field, Class fieldClass,
   * Object value).
   */
  public boolean setValue(String field, Object value);
  /**
   * Determines whether the two given values of the given field differ
   */
  public boolean sameValue(String field, Object value, Object otherValue);

  public void addDataChangeListener(DataChangeListener l);
  public void removeDataChangeListener(DataChangeListener l);

}
