/****************************************************************************
 * An event that describes a change to an object, e.g. to a domain construct
 *
 * File: ObjectChangeEvent.java
 * @author Jussi Stader
 * @version 4.1
 * Updated: Mon Apr 24 16:23:11 2006
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 ****************************************************************************
 */

package ix.icore.event;

import java.beans.PropertyChangeEvent;
import java.lang.*;

public class ObjectChangeEvent extends PropertyChangeEvent {
  protected Object object;

    /** Use this for added/removed events */
  public ObjectChangeEvent(Object source, Object edited) {
    this(source, edited, "", null, null);
  }
    /** Use this for edited events */
  public ObjectChangeEvent(Object source, Object edited, String field, 
			   Object oldValue, Object newValue) {
    super(source, field, oldValue, newValue);
    this.object = edited;
  }
  public Object getObject() { return object; }
  public String getField() { return getPropertyName(); }

  public boolean isNameChange() {
    if (getField() != null) 
      return (getField().equals("name") || getField().equals("Name"));
    else return false;
  }

  public String print() {
    String old = "null";
    if (getOldValue() != null) old = getOldValue().toString();
    return "ObjectChangeEvent from source " +getSource().toString()+ 
      ": object is " +getObject().toString()+ ", field is: " +getField()+ 
      ", old value is: " +old;
  }

}
