/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Dec  7 15:28:36 2007 by Jeff Dalton
 * Copyright: (c) 2005 - 2007, AIAI, University of Edinburgh
 */

package ix.util.http;

import java.net.*;
import java.io.*;
import java.util.*;

import ix.util.*;

/**
 * Makes HTTP requests that can be regarded as sending a string
 * and receiving one in reply.  The string may of course contain
 * XML if desired.
 *
 * <p>Certain reasonable assumptions are made about the requests:
 * <ul>
 * <li>The Content-Type for sending strings is "text/plain";
 * <li>The charset is UTF-8.
 * </ul>
 *
 * Both can be changed by calling "set" methods.
 *
 * <p>At present, only POST requests can be made.
 *
 * @see HttpStringServlet
 * @see HttpServer
 */
public class HttpStringClient extends HttpObjectClient {

    public HttpStringClient() {
	this.requestContentType = "text/plain";
    }

    /**
     * Send a string and receive one in reply.  If an object that isn't
     * a string is given as the contents to send, it is converted to a
     * string by calling it's <code>toString()</code> method.
     */
    @Override
    public String sendRequest(URL url, Object contentsToSend) {
	return (String)super.sendRequest(url, contentsToSend.toString());
    }

    @Override
    protected byte[] encodeForSend(Object obj) 
	throws UnsupportedEncodingException {
	return ((String)obj).getBytes(requestCharsetName);
    }

    @Override
    protected String decodeReceived(String contents) {
	return contents;
    }

    /**
     * Main program for testing.
     */
    public static void main(String[] argv) throws Exception {

	class Identity implements Fn1<String,Object> {
	    public Object funcall(String arg) {
		return arg;
	    }
	}

	mainLoop(argv, new HttpStringClient(), new Identity());

    }

}
