/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Nov 25 15:01:57 2007 by Jeff Dalton
 * Copyright: (c) 2007, AIAI, University of Edinburgh
 */

package ix.util.http;

import java.io.IOException;

public class HttpRequestException extends IOException {

    private int status;
    private String reason;

    public HttpRequestException(int status, String reason) {
	super("HTTP request returned " + status + ": " + reason);
	this.status = status;
	this.reason = reason;
    }

    public int getStatus() {
	return status;
    }

    public String getReason() {
	return reason;
    }

}
