/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Nov 24 22:14:26 2007 by Jeff Dalton
 * Copyright: (c) 2007, AIAI, University of Edinburgh
 */

package ix.util.http;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ix.util.Strings;
import ix.util.Debug;

/**
 * Test servlet.
 */
public class HelloServlet extends HttpServlet {

    private String message;

    public HelloServlet(String message) {
	this.message = message;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp)
	      throws ServletException, IOException {
	Debug.noteln("HelloServlet will reply", Strings.quote(message));
	resp.setContentType("text/plain");
	resp.setStatus(HttpServletResponse.SC_OK);
	resp.getWriter().println(message);
    }

}
